% -----------------------------------------------------
% FLEAPFROG: Resuelve ecuaciones diferenciales del tipo
% y' = f(x,y) usando el
% mtodo Leapfrog utilizando una malla
% equiespaciada con Nh intervalos.
%
% PARMETROS DE ENTRADA:
% fun: puntero a funcin. Es importante que la funcin est definida como
% una funcin de dos variables f(x,y,k1,k2,..,kn) por este orden.
% k1,k2,..,kn son todos los otros parmetros que puede haber en la funcin
% y que pasamos a travs de varargin.
% x0: valor inicial de la variable independiente
% xf: valor final de la variable independiente
% y0: variable con el valor inicial de y
% Nh: nmero de intervalos que tomamos entre el instante inicial y final.
% Por ejemplo, si Nh=3, dividimos el tiempo entre el instante inicial y el
% final en tres intervalos.
% varargin: los valores de los parmetros k1,k2,..,kn que puede haber en la funcin
%
% PARMETROS DE SALIDA:
% x: vector columna con los valores de la variable independiente en los que se ha
% evaluado y.
% y: vector columna con lo valores de la funcin y
% -----------------------------------------------------

function [x,y]=fLeapfrog(fun,x0,xf,y0,Nh)
h=(xf-x0)/Nh;
x=zeros(1,Nh+1);
y=zeros(1,Nh+1);
x(1)=x0;
y(1)=y0;
for j=2:1:Nh+1
    f1 = fun(x(j-1),y(j-1));
    xm = x(j-1)+h/2;
    ym = y(j-1)+h/2*f1;
    fm = fun(xm,ym);
    y(j) = y(j-1)+h*fm;
    x(j) = h+x(j-1);
end
return
